<!-- Breadcrumb Section -->
<section class="z-index-2 position-relative pb-2 mb-12">
    <div class="bg-body-secondary mb-3">
        <div class="container">
            <nav class="py-4 lh-30px" aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center py-1 mb-0">
                    <li class="breadcrumb-item"><a title="Home" href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Order Confirmation</li>
                </ol>
            </nav>
        </div>
    </div>
</section>

<!-- Order Confirmation Section -->
<section class="container pb-14 pb-lg-19">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Success Message -->
            <div class="text-center mb-12">
                <div class="mb-8">
                    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" fill="currentColor" class="text-success" viewBox="0 0 16 16">
                        <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
                    </svg>
                </div>
                <h2 class="fs-1 mb-4">Thank You for Your Pre-Order!</h2>
                <p class="fs-18px text-muted mb-6">Your pre-order has been received and is being processed.</p>
                <p class="mb-0">
                    <span class="fw-bold">Order ID:</span> 
                    <span class="text-primary"><?=$order->orderId?></span>
                </p>
            </div>

            <!-- Order Details Card -->
            <div class="card border-0 shadow mb-10">
                <div class="card-header bg-dark text-white py-6">
                    <h4 class="mb-0 fs-5">Order Details</h4>
                </div>
                <div class="card-body p-8">
                    <div class="row mb-6">
                        <div class="col-sm-6 mb-4 mb-sm-0">
                            <h6 class="text-muted mb-2">Order Date</h6>
                            <p class="mb-0 fw-semibold"><?=date('F j, Y \a\t g:i A', strtotime($order->checkDate))?></p>
                        </div>
                        <div class="col-sm-6">
                            <h6 class="text-muted mb-2">Order Status</h6>
                            <span class="badge bg-warning text-dark px-4 py-2 fs-14px text-uppercase"><?=$order->order_status?></span>
                        </div>
                    </div>
                    
                    <div class="row mb-6">
                        <div class="col-sm-6 mb-4 mb-sm-0">
                            <h6 class="text-muted mb-2">Payment Method</h6>
                            <p class="mb-0 fw-semibold">
                                <?php 
                                    $payment_icons = [
                                        'card' => '<i class="fas fa-credit-card me-2"></i>Credit/Debit Card',
                                        'paypal' => '<i class="fab fa-paypal me-2"></i>PayPal'
                                    ];
                                    echo isset($payment_icons[$order->payment_method]) ? $payment_icons[$order->payment_method] : ucfirst($order->payment_method);
                                ?>
                            </p>
                        </div>
                        <div class="col-sm-6">
                            <h6 class="text-muted mb-2">Payment Status</h6>
                            <span class="badge bg-info px-4 py-2 fs-14px text-uppercase"><?=$order->transaction_status?></span>
                        </div>
                    </div>

                    <hr class="my-6">

                    <h6 class="mb-4">Shipping Address</h6>
                    <p class="mb-0">
                        <strong><?=$order->firstname?> <?=$order->lastname?></strong><br>
                        <?=$order->address?><br>
                        <?=$order->country?><br>
                        <i class="fas fa-phone me-1"></i> <?=$order->phone?><br>
                        <i class="fas fa-envelope me-1"></i> <?=$order->email?>
                    </p>
                </div>
            </div>

            <!-- Order Items Card -->
            <div class="card border-0 shadow mb-10">
                <div class="card-header bg-body-secondary py-6">
                    <h4 class="mb-0 fs-5">Order Items</h4>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-borderless mb-0">
                            <thead class="bg-body-tertiary">
                                <tr>
                                    <th class="py-4 ps-8">Product</th>
                                    <th class="py-4 text-center">Qty</th>
                                    <th class="py-4 text-end pe-8">Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                    $subtotal = 0;
                                    foreach($order_items as $item): 
                                        $item_price = $item->amount;
                                        if($item->discount_percentage) {
                                            $item_price = $item->amount - ($item->amount * ($item->discount_percentage / 100));
                                        }
                                        $line_total = $item_price * $item->quantity;
                                        $subtotal += $line_total;
                                ?>
                                    <tr class="border-bottom">
                                        <td class="py-6 ps-8">
                                            <div class="d-flex align-items-center">
                                                <img src="<?=PRODUCT_ASSETS_URL.$item->image?>" width="60" height="80" alt="<?=$item->name?>" class="rounded me-4">
                                                <div>
                                                    <h6 class="mb-1"><?=$item->name?></h6>
                                                    <?php if($item->size): ?>
                                                        <small class="text-muted">Size: <?=$item->size?></small><br>
                                                    <?php endif; ?>
                                                    <?php if($item->colorName): ?>
                                                        <small class="text-muted">Color: <?=$item->colorName?></small>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="py-6 text-center align-middle"><?=$item->quantity?></td>
                                        <td class="py-6 text-end pe-8 align-middle fw-semibold"><?=currency_main_symbol($line_total, 1)?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="bg-body-tertiary">
                                <tr>
                                    <td colspan="2" class="py-4 ps-8 text-end">Subtotal:</td>
                                    <td class="py-4 pe-8 text-end fw-semibold"><?=currency_main_symbol($order->amount, 1)?></td>
                                </tr>
                                <?php if($order->coupon_percentage > 0): ?>
                                    <tr>
                                        <td colspan="2" class="py-4 ps-8 text-end">Discount (<?=$order->coupon_percentage?>%):</td>
                                        <td class="py-4 pe-8 text-end fw-semibold text-success">-<?=currency_main_symbol($order->amount - $order->finalAmount, 1)?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if($order->delivery_fee > 0): ?>
                                    <tr>
                                        <td colspan="2" class="py-4 ps-8 text-end">Shipping:</td>
                                        <td class="py-4 pe-8 text-end fw-semibold"><?=currency_main_symbol($order->delivery_fee, 1)?></td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="border-top">
                                    <td colspan="2" class="py-4 ps-8 text-end fs-5 fw-bold">Total:</td>
                                    <td class="py-4 pe-8 text-end fs-5 fw-bold text-primary"><?=currency_main_symbol($order->finalAmount, 1)?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <!-- What's Next Section -->
            <div class="card border-0 shadow mb-10">
                <div class="card-body p-8">
                    <h5 class="mb-6"><i class="fas fa-info-circle text-primary me-2"></i>What's Next?</h5>
                    <div class="row">
                        <div class="col-md-4 mb-6 mb-md-0">
                            <div class="text-center">
                                <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-4" style="width: 50px; height: 50px;">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <h6>Confirmation Email</h6>
                                <p class="text-muted fs-14px mb-0">You'll receive an order confirmation email at <?=$order->email?></p>
                            </div>
                        </div>
                        <div class="col-md-4 mb-6 mb-md-0">
                            <div class="text-center">
                                <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-4" style="width: 50px; height: 50px;">
                                    <i class="fas fa-box"></i>
                                </div>
                                <h6>Order Processing</h6>
                                <p class="text-muted fs-14px mb-0">We'll prepare your items for shipment once available</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center">
                                <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-4" style="width: 50px; height: 50px;">
                                    <i class="fas fa-shipping-fast"></i>
                                </div>
                                <h6>Shipping Update</h6>
                                <p class="text-muted fs-14px mb-0">You'll receive tracking info when your order ships</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="text-center">
                <a href="<?=base_url('products')?>" class="btn btn-outline-dark px-10 me-4 mb-4">
                    <i class="fas fa-shopping-bag me-2"></i>Continue Shopping
                </a>
                <a href="<?=base_url('products/my_orders')?>" class="btn btn-dark px-10 mb-4">
                    <i class="fas fa-list me-2"></i>View My Orders
                </a>
            </div>

            <!-- Print Button -->
            <div class="text-center mt-6">
                <button onclick="window.print()" class="btn btn-link text-muted">
                    <i class="fas fa-print me-2"></i>Print Order Confirmation
                </button>
            </div>
        </div>
    </div>
</section>

<style>
@media print {
    header, footer, .btn, nav, .breadcrumb {
        display: none !important;
    }
    .card {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
    }
}
</style>

