<!-- Breadcrumb Section -->
<section class="z-index-2 position-relative pb-2 mb-12">
    <div class="bg-body-secondary mb-3">
        <div class="container">
            <nav class="py-4 lh-30px" aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center py-1 mb-0">
                    <li class="breadcrumb-item"><a title="Home" href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item"><a title="Pre-Orders" href="<?=base_url('products/cart')?>">Pre-Orders</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Check Out</li>
                </ol>
            </nav>
        </div>
    </div>
</section>

<!-- Checkout Section -->
<section class="container pb-14 pb-lg-19">
    <div class="text-center"><h2 class="mb-6">Check Out</h2></div>

    <?php 
        $subtotal = 0;
        foreach($cart_items as $item) {
            $item_price = $item->amount;
            if($item->discount_percentage) {
                $item_price = $item->amount - ($item->amount * ($item->discount_percentage / 100));
            }
            $subtotal += $item_price * $item->quantity;
        }
    ?>

    <form class="pt-12" id="checkoutForm" method="post" action="<?=base_url('products/place_order')?>">
        <div class="row">
            <!-- Order Summary (Right Side) -->
            <div class="col-lg-4 pb-lg-0 pb-14 order-lg-last">
                <div class="card border-0 rounded-0 shadow">
                    <div class="card-header px-0 mx-10 bg-transparent py-8">
                        <h4 class="fs-4 mb-8">Order Summary</h4>
                        
                        <?php foreach($cart_items as $item): ?>
                            <?php 
                                $item_price = $item->amount;
                                if($item->discount_percentage) {
                                    $item_price = $item->amount - ($item->amount * ($item->discount_percentage / 100));
                                }
                            ?>
                            <div class="d-flex w-100 mb-7">
                                <div class="me-6">
                                    <img src="<?=PRODUCT_ASSETS_URL.$item->image?>" width="60" height="80" alt="<?=$item->name?>" class="rounded">
                                </div>
                                <div class="d-flex flex-grow-1">
                                    <div class="pe-6">
                                        <a href="<?=base_url('products/view/'.$item->slug.'/'.$item->productUnique)?>" class="text-reset text-decoration-none">
                                            <?=$item->name?><span class="text-body"> x<?=$item->quantity?></span>
                                        </a>
                                        <?php if($item->size): ?>
                                            <p class="fs-14px text-body-emphasis mb-0 mt-1">Size:
                                                <span class="text-body"><?=$item->size?></span>
                                            </p>
                                        <?php endif; ?>
                                        <?php if($item->colorName): ?>
                                            <p class="fs-14px text-body-emphasis mb-0 mt-1">Color:
                                                <span class="text-body"><?=$item->colorName?></span>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="ms-auto">
                                        <p class="fs-14px text-body-emphasis mb-0 fw-bold"><?=currency_main_symbol($item_price * $item->quantity, 1)?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="card-body px-10 py-8">
                        <div class="d-flex align-items-center mb-2">
                            <span>Subtotal:</span>
                            <span class="d-block ms-auto text-body-emphasis fw-bold"><?=currency_main_symbol($subtotal, 1)?></span>
                        </div>
                        <div class="d-flex align-items-center">
                            <span>Shipping:</span>
                            <span class="d-block ms-auto text-body-emphasis fw-bold">Calculated</span>
                        </div>
                    </div>
                    <div class="card-footer bg-transparent py-5 px-0 mx-10">
                        <div class="d-flex align-items-center fw-bold mb-6">
                            <span class="text-body-emphasis p-0">Total:</span>
                            <span class="d-block ms-auto text-body-emphasis fs-4 fw-bold"><?=currency_main_symbol($subtotal, 1)?></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Checkout Form (Left Side) -->
            <div class="col-lg-8 order-lg-first pe-xl-20 pe-lg-6">
                <div class="checkout">
                    <?php if (!isset($_SESSION) || !isset($_SESSION['login']) || !$_SESSION['login']->userId): ?>
                        <p class="mb-5">Already have an account?
                            <a href="<?=base_url('auth/login')?>">Click here to login</a>
                        </p>
                    <?php endif; ?>
                    
                    <p>Have a coupon?
                        <a data-bs-toggle="collapse" href="#collapsecoupon" role="button" aria-expanded="false" aria-controls="collapsecoupon">Click here to enter your code</a>
                    </p>
                    <div class="collapse" id="collapsecoupon">
                        <div class="card mw-60 border-0">
                            <div class="card-body py-10 px-8 my-10 border">
                                <p class="card-text text-body-emphasis mb-8">
                                    If you have a coupon code, please apply it below.</p>
                                <div class="input-group position-relative">
                                    <input type="text" class="form-control bg-body rounded-end" name="coupon_code" placeholder="Coupon Code">
                                    <button type="button" id="applyCouponBtn" class="btn btn-dark btn-hover-bg-primary btn-hover-border-primary">
                                        Apply Coupon
                                    </button>
                                </div>
                                <div id="couponMessage" class="mt-3"></div>
                            </div>
                        </div>
                    </div>
                    
                    <h4 class="fs-4 pt-4 mb-7">Shipping Information</h4>

                    <div class="mb-7">
                        <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">Name</label>
                        <div class="row">
                            <div class="col-md-6 mb-md-0 mb-7">
                                <input type="text" class="form-control" name="first_name" placeholder="First Name" required>
                            </div>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="last_name" placeholder="Last Name" required>
                            </div>
                        </div>
                    </div>

                    <div class="mb-7">
                        <div class="row">
                            <div class="col-md-8 mb-md-0 mb-7">
                                <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">Street Address</label>
                                <input type="text" class="form-control" name="street_address" required>
                            </div>
                            <div class="col-md-4">
                                <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">APT/Suite</label>
                                <input type="text" class="form-control" name="apt_suite">
                            </div>
                        </div>
                    </div>

                    <div class="mb-7">
                        <div class="row">
                            <div class="col-md-4 mb-md-0 mb-7">
                                <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">City</label>
                                <input type="text" class="form-control" name="city" required>
                            </div>
                            <div class="col-md-4 mb-md-0 mb-7">
                                <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">State</label>
                                <input type="text" class="form-control" name="state" required>
                            </div>
                            <div class="col-md-4">
                                <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">Zip Code</label>
                                <input type="text" class="form-control" name="zip" required>
                            </div>
                        </div>
                    </div>

                    <div class="mb-7">
                        <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">Country</label>
                        <select name="country" class="form-select" required>
                            <option value="">Select Country</option>
                            <option value="US">United States</option>
                            <option value="CA">Canada</option>
                            <option value="GB">United Kingdom</option>
                            <option value="AU">Australia</option>
                            <option value="DE">Germany</option>
                            <option value="FR">France</option>
                            <option value="IT">Italy</option>
                            <option value="ES">Spain</option>
                            <option value="NL">Netherlands</option>
                            <option value="JP">Japan</option>
                        </select>
                    </div>

                    <div class="mb-7">
                        <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">Contact Info</label>
                        <div class="row">
                            <div class="col-md-6 mb-md-0 mb-7">
                                <input type="email" class="form-control" name="email" placeholder="Email Address" required>
                            </div>
                            <div class="col-md-6">
                                <input type="tel" class="form-control" name="phone" placeholder="Phone Number" required>
                            </div>
                        </div>
                    </div>

                    <div class="mb-7">
                        <label class="mb-5 fs-13px letter-spacing-01 fw-semibold text-uppercase">Order Notes (Optional)</label>
                        <textarea class="form-control" name="order_notes" rows="4" placeholder="Notes about your order, e.g. special notes for delivery"></textarea>
                    </div>

                    <h4 class="fs-4 pt-8 mb-7">Payment Method</h4>

                    <div class="accordion mb-8" id="paymentAccordion">
                        <div class="accordion-item border mb-4">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#paymentCard">
                                    <input class="form-check-input me-3" type="radio" name="payment_method" value="card" checked>
                                    Credit/Debit Card
                                </button>
                            </h2>
                            <div id="paymentCard" class="accordion-collapse collapse show" data-bs-parent="#paymentAccordion">
                                <div class="accordion-body">
                                    <div class="mb-5">
                                        <input type="text" class="form-control" name="card_number" placeholder="Card Number">
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-md-0 mb-5">
                                            <input type="text" class="form-control" name="card_expiry" placeholder="MM/YY">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" class="form-control" name="card_cvv" placeholder="CVV">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item border">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#paymentPaypal">
                                    <input class="form-check-input me-3" type="radio" name="payment_method" value="paypal">
                                    PayPal
                                </button>
                            </h2>
                            <div id="paymentPaypal" class="accordion-collapse collapse" data-bs-parent="#paymentAccordion">
                                <div class="accordion-body">
                                    <p class="text-muted">You will be redirected to PayPal to complete your payment.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-check mb-8">
                        <input class="form-check-input" type="checkbox" name="terms_agreed" id="termsAgree" required>
                        <label class="form-check-label" for="termsAgree">
                            I have read and agree to the <a href="<?=base_url('terms')?>">Terms & Conditions</a> and <a href="<?=base_url('privacy')?>">Privacy Policy</a>
                        </label>
                    </div>

                    <button type="submit" class="btn btn-dark btn-lg w-100 btn-hover-bg-primary btn-hover-border-primary">
                        <i class="fas fa-lock me-2"></i> Place Pre-Order
                    </button>
                    
                    <p class="text-center text-muted fs-13px mt-4">
                        <i class="fas fa-shield-alt me-1"></i> Your payment information is secure and encrypted
                    </p>
                </div>
            </div>
        </div>
    </form>
</section>

<script>
$(document).ready(function() {
    // Apply coupon
    $('#applyCouponBtn').on('click', function() {
        var couponCode = $('input[name="coupon_code"]').val();
        if (!couponCode) {
            $('#couponMessage').html('<div class="alert alert-warning">Please enter a coupon code</div>');
            return;
        }
        
        $.ajax({
            type: 'POST',
            url: '<?=base_url("products/apply_coupon")?>',
            data: { coupon_code: couponCode },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#couponMessage').html('<div class="alert alert-success">' + response.message + '</div>');
                } else {
                    $('#couponMessage').html('<div class="alert alert-danger">' + response.message + '</div>');
                }
            }
        });
    });
    
    // Payment method accordion toggle
    $('.accordion-button').on('click', function() {
        $(this).find('input[type="radio"]').prop('checked', true);
    });
});
</script>

