<?php
if(!isset($_COOKIE['userUnique']) && !$_SESSION['login']->verification_link) {
  $cookie_name = "userUnique";
  $cookie_value = Unique::generate();
  setcookie($cookie_name, $cookie_value, time() + (86400 * 365), "/");
}
?>
<!doctype html>
<html lang="en" data-bs-theme="light">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title><?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?></title>
  <meta name="description" content="<?=$this->settings_m->getOne(array('s_key' => 'app_description'))->s_value;?>">
  <link rel="icon" href="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_dark_symbol'))->s_value;?>">

  <!-- Vendor CSS -->
  <link rel="stylesheet" href="<?=base_url()?>frontend/assets/vendors/lightgallery/css/lightgallery-bundle.min.css">
  <link rel="stylesheet" href="<?=base_url()?>frontend/assets/vendors/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="<?=base_url()?>frontend/assets/vendors/animate/animate.min.css">
  <link rel="stylesheet" href="<?=base_url()?>frontend/assets/vendors/slick/slick.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
  
  <!-- Theme CSS -->
  <link rel="stylesheet" href="<?=base_url()?>frontend/assets/css/theme.css">
  
  <!-- jQuery -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  
  <!-- Toastify -->
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
  
  <!-- PayPal SDK -->
  <script src="https://www.paypal.com/sdk/js?client-id=<?=$this->transactions_m->getOnePaymentMethod(['channel_code' => 'paypal'])->public_key;?>"></script>

  <style>
    /* Custom Sentrie Styles */
    .header-logo-img {
      max-width: 120px;
      height: auto;
    }
    
    @media only screen and (max-width: 767px) {
      .header-logo-img {
        max-width: 80px;
      }
    }
  </style>
</head>

<body>
  <?php country_getter(); ?>
  
  <!-- SVG Icon Sprites -->
  <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
    <symbol id="icon-arrow-right" viewBox="0 0 32 32">
      <path d="M4 16c0-0.552 0.448-1 1-1h22c0.552 0 1 0.448 1 1s-0.448 1-1 1h-22c-0.552 0-1-0.448-1-1zM17.293 6.293c0.391-0.391 1.024-0.391 1.414 0l9 9c0.39 0.391 0.39 1.024 0 1.414l-9 9c-0.391 0.39-1.024 0.39-1.414 0s-0.39-1.024 0-1.414l8.293-8.293-8.293-8.293c-0.39-0.391-0.39-1.024 0-1.414z"></path>
    </symbol>
    <symbol id="icon-heart" viewBox="0 0 32 32">
      <path d="M23.268 2.4c-2.65 0-4.973 1.182-6.717 3.417-0.233 0.298-0.44 0.596-0.624 0.885-0.184-0.289-0.391-0.587-0.624-0.885-1.745-2.235-4.068-3.417-6.717-3.417-5.005 0-8.586 4.191-8.586 9.22 0 5.751 4.713 11.17 15.282 17.573 0.198 0.12 0.421 0.18 0.645 0.18s0.447-0.060 0.645-0.18c10.569-6.403 15.282-11.822 15.282-17.573 0-5.027-3.577-9.22-8.586-9.22zM26.077 18.781c-2.2 2.455-5.525 5.040-10.151 7.89-4.625-2.85-7.95-5.435-10.151-7.89-2.212-2.468-3.288-4.811-3.288-7.161 0-3.621 2.447-6.732 6.097-6.732 1.859 0 3.444 0.808 4.711 2.402 1.013 1.275 1.44 2.591 1.443 2.6 0.162 0.52 0.643 0.874 1.188 0.874s1.026-0.354 1.188-0.874c0.004-0.013 0.418-1.288 1.398-2.543 1.274-1.632 2.874-2.459 4.756-2.459 3.654 0 6.097 3.114 6.097 6.732 0 2.35-1.075 4.692-3.288 7.161z"></path>
    </symbol>
    <symbol id="icon-cart" viewBox="0 0 32 32">
      <path d="M31.024 5.672c-0.4-0.512-1.016-0.808-1.688-0.808h-23.4l-0.592-2.896c-0.2-0.984-1.064-1.696-2.072-1.696h-2.024c-0.584 0-1.056 0.472-1.056 1.056s0.472 1.056 1.056 1.056h2.024l3.32 16.256c0.2 0.984 1.064 1.696 2.072 1.696h16.2c0.584 0 1.056-0.472 1.056-1.056s-0.472-1.056-1.056-1.056h-16.2l-0.432-2.112h17.024c1.008 0 1.872-0.712 2.072-1.696l2.184-10.688c0.12-0.584-0.032-1.2-0.432-1.712-0.016-0.016-0.032-0.032-0.056-0.048zM28.264 7.384l-2.184 10.688h-17.024l-2.184-10.688h21.392z"></path>
      <path d="M11.768 22.32c-1.76 0-3.192 1.432-3.192 3.192s1.432 3.192 3.192 3.192c1.76 0 3.192-1.432 3.192-3.192s-1.432-3.192-3.192-3.192zM11.768 26.592c-0.6 0-1.080-0.48-1.080-1.080s0.48-1.080 1.080-1.080c0.6 0 1.080 0.48 1.080 1.080s-0.48 1.080-1.080 1.080z"></path>
      <path d="M23.768 22.32c-1.76 0-3.192 1.432-3.192 3.192s1.432 3.192 3.192 3.192c1.76 0 3.192-1.432 3.192-3.192s-1.432-3.192-3.192-3.192zM23.768 26.592c-0.6 0-1.080-0.48-1.080-1.080s0.48-1.080 1.080-1.080c0.6 0 1.080 0.48 1.080 1.080s-0.48 1.080-1.080 1.080z"></path>
    </symbol>
    <symbol id="icon-user" viewBox="0 0 32 32">
      <path d="M16 16c4.418 0 8-3.582 8-8s-3.582-8-8-8-8 3.582-8 8 3.582 8 8 8zM16 2.4c3.088 0 5.6 2.512 5.6 5.6s-2.512 5.6-5.6 5.6-5.6-2.512-5.6-5.6 2.512-5.6 5.6-5.6zM16 18.4c-6.296 0-12 4.216-12 8.8 0 2.648 0 4.4 0 4.4 0 0.664 0.536 1.2 1.2 1.2h21.6c0.664 0 1.2-0.536 1.2-1.2 0 0 0-1.752 0-4.4 0-4.584-5.704-8.8-12-8.8zM25.6 30.4h-19.2v-3.2c0-2.64 4.272-6.4 9.6-6.4s9.6 3.76 9.6 6.4v3.2z"></path>
    </symbol>
    <symbol id="icon-search" viewBox="0 0 32 32">
      <path d="M31.608 30.192l-8.792-8.792c1.904-2.304 3.048-5.264 3.048-8.472 0-7.376-5.984-13.36-13.36-13.36s-13.36 5.984-13.36 13.36 5.984 13.36 13.36 13.36c3.208 0 6.168-1.144 8.472-3.048l8.792 8.792c0.392 0.392 1.024 0.392 1.416 0 0.392-0.392 0.392-1.024 0-1.416zM12.504 24.272c-6.272 0-11.36-5.088-11.36-11.36s5.088-11.36 11.36-11.36 11.36 5.088 11.36 11.36-5.088 11.36-11.36 11.36z"></path>
    </symbol>
    <!-- Star icons for ratings -->
    <symbol id="star" viewBox="0 0 32 32">
      <path d="M16 0l4.944 9.984 11.056 1.608-8 7.808 1.888 11.040-9.888-5.184-9.888 5.184 1.888-11.040-8-7.808 11.056-1.608z"></path>
    </symbol>
    <symbol id="star-o" viewBox="0 0 32 32">
      <path d="M16 0l4.944 9.984 11.056 1.608-8 7.808 1.888 11.040-9.888-5.184-9.888 5.184 1.888-11.040-8-7.808 11.056-1.608zM16 4.8l-3.52 7.136-7.872 1.144 5.696 5.552-1.344 7.84 7.040-3.696 7.040 3.696-1.344-7.84 5.696-5.552-7.872-1.144z"></path>
    </symbol>
    <!-- Shop page icons -->
    <symbol id="icon-star-light" viewBox="0 0 32 32">
      <path d="M23.408 28.748c-0.354-0-0.683-0.104-0.96-0.283l0.007 0.004-6.304-3.994c-0.042-0.028-0.094-0.044-0.15-0.044s-0.108 0.016-0.151 0.045l0.001-0.001-5.859 3.712c-0.3 0.198-0.669 0.316-1.064 0.316-0.439 0-0.844-0.145-1.17-0.39l0.005 0.004c-0.515-0.377-0.846-0.979-0.846-1.658 0-0.184 0.024-0.362 0.070-0.532l-0.003 0.014 1.689-6.645c0.007-0.026 0.012-0.057 0.012-0.088 0-0.104-0.046-0.197-0.119-0.26l-0-0-5.653-4.705c-0.405-0.339-0.661-0.844-0.661-1.41 0-0.207 0.034-0.406 0.097-0.591l-0.004 0.013c0.225-0.695 0.845-1.199 1.588-1.25l0.006-0 7.383-0.479c0.119-0.010 0.217-0.088 0.257-0.195l0.001-0.002 2.754-6.934c0.266-0.675 0.913-1.144 1.669-1.144s1.403 0.469 1.665 1.132l0.004 0.012 2.754 6.934c0.040 0.109 0.139 0.187 0.256 0.197l0.001 0 7.383 0.479c0.749 0.051 1.369 0.555 1.59 1.237l0.004 0.013c0.059 0.173 0.093 0.371 0.093 0.578 0 0.565-0.256 1.071-0.658 1.408l-0.003 0.002-5.654 4.705c-0.073 0.063-0.119 0.156-0.119 0.26 0 0.031 0.004 0.062 0.012 0.091l-0.001-0.002 1.822 7.165c0.038 0.139 0.060 0.299 0.060 0.464 0 0.676-0.364 1.267-0.907 1.588l-0.009 0.005c-0.282 0.178-0.626 0.284-0.994 0.284-0.007 0-0.014-0-0.021-0l0.001 0z"></path>
    </symbol>
    <symbol id="icon-shopping-bag-open-light" viewBox="0 0 32 32">
      <path d="M27 5.25h-22c-0.966 0.001-1.749 0.784-1.75 1.75v18c0.001 0.966 0.784 1.749 1.75 1.75h22c0.966-0.001 1.749-0.784 1.75-1.75v-18c-0.001-0.966-0.784-1.749-1.75-1.75h-0zM5 6.75h22c0.138 0 0.25 0.112 0.25 0.25v2.25h-22.5v-2.25c0-0.138 0.112-0.25 0.25-0.25h0zM27 25.25h-22c-0.138-0-0.25-0.112-0.25-0.25v-14.25h22.5v14.25c-0 0.138-0.112 0.25-0.25 0.25h-0zM21.75 14c0 3.176-2.574 5.75-5.75 5.75s-5.75-2.574-5.75-5.75v0c0-0.414 0.336-0.75 0.75-0.75s0.75 0.336 0.75 0.75v0c0 2.347 1.903 4.25 4.25 4.25s4.25-1.903 4.25-4.25v0c0-0.414 0.336-0.75 0.75-0.75s0.75 0.336 0.75 0.75v0z"></path>
    </symbol>
    <symbol id="icon-squares-four" viewBox="0 0 32 32">
      <path d="M14 5h-8c0 0 0 0 0 0-0.552 0-1 0.448-1 1 0 0 0 0 0 0v0 8c0 0 0 0 0 0 0 0.552 0.448 1 1 1 0 0 0 0 0 0h8c0 0 0 0 0 0 0.552 0 1-0.448 1-1 0 0 0 0 0 0v0-8c0 0 0 0 0 0 0-0.552-0.448-1-1-1 0 0 0 0 0 0v0zM13 13h-6v-6h6zM26 5h-8c0 0 0 0 0 0-0.552 0-1 0.448-1 1 0 0 0 0 0 0v0 8c0 0 0 0 0 0 0 0.552 0.448 1 1 1 0 0 0 0 0 0h8c0 0 0 0 0 0 0.552 0 1-0.448 1-1 0 0 0 0 0 0v0-8c0 0 0 0 0 0 0-0.552-0.448-1-1-1 0 0 0 0 0 0v0zM25 13h-6v-6h6zM14 17h-8c0 0 0 0 0 0-0.552 0-1 0.448-1 1 0 0 0 0 0 0v0 8c0 0 0 0 0 0 0 0.552 0.448 1 1 1 0 0 0 0 0 0h8c0 0 0 0 0 0 0.552 0 1-0.448 1-1 0 0 0-0 0-0v0-8c0 0 0 0 0 0 0-0.552-0.448-1-1-1 0 0 0 0 0 0v0zM13 25h-6v-6h6zM26 17h-8c0 0 0 0 0 0-0.552 0-1 0.448-1 1 0 0 0 0 0 0v0 8c0 0 0 0 0 0 0 0.552 0.448 1 1 1 0 0 0 0 0 0h8c0 0 0 0 0 0 0.552 0 1-0.448 1-1 0 0 0-0 0-0v0-8c0 0 0 0 0 0 0-0.552-0.448-1-1-1 0 0 0 0 0 0v0zM25 25h-6v-6h6z"></path>
    </symbol>
  </svg>

  <?php if ($this->uri->segment(2) == "checkout" || $this->uri->segment(2) == "payment" || $this->uri->segment(2) == "order_success"){ }else{ ?>
  
  <!-- Header -->
  <header id="header" class="header header-sticky header-sticky-smart disable-transition-all z-index-5">
    <!-- Top Bar -->
    <div class="topbar bg-dark">
      <div class="container-wide container">
        <p class="mb-0 text-white text-center p-4 fs-15px fw-bold ls-1 text-uppercase">Free shipping on all U.S. orders $50+</p>
      </div>
    </div>
    
    <div class="sticky-area">
      <div class="main-header nav navbar bg-body navbar-light navbar-expand-xl py-6 py-xl-0">
        <div class="container-xxl container">
          
          <!-- Mobile Header -->
          <div class="d-flex d-xl-none w-100">
            <div class="w-72px d-flex d-xl-none">
              <button class="navbar-toggler align-self-center border-0 shadow-none px-0 canvas-toggle p-4" type="button"
                  data-bs-toggle="offcanvas"
                  data-bs-target="#offCanvasNavBar"
                  aria-controls="offCanvasNavBar"
                  aria-expanded="false"
                  aria-label="Toggle Navigation">
                <span class="fs-24 toggle-icon"></span>
              </button>
            </div>
            
            <div class="d-flex mx-auto">
              <a href="<?=base_url()?>" class="navbar-brand px-8 py-4 mx-auto">
                <img class="light-mode-img header-logo-img" style="width: 50px; height: auto;" src="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_dark'))->s_value;?>" alt="<?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?>">
                <img class="dark-mode-img header-logo-img" style="width: 50px; height: auto;" src="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_white_text'))->s_value;?>" alt="<?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?>">
              </a>
            </div>
            
            <div class="icons-actions d-flex justify-content-end w-xl-50 fs-28px text-body-emphasis w-72px">
              <div class="px-xl-5 d-inline-block">
                <a class="lh-1 color-inherit text-decoration-none" href="#" data-bs-toggle="offcanvas" data-bs-target="#searchModal" aria-controls="searchModal" aria-expanded="false">
                  <svg class="icon icon-magnifying-glass-light">
                    <use xlink:href="#icon-magnifying-glass-light"></use>
                  </svg>
                </a>
              </div>
            </div>
          </div>

          <!-- Desktop Header -->
          <div class="d-none d-xl-flex flex-column flex-xl-row w-100">
            <!-- Left Navigation -->
            <div class="w-auto w-xl-50 d-flex align-items-center">
              <div class="icons-actions d-none d-xl-flex justify-content-start me-auto fs-28px text-body-emphasis">
                <div class="pe-6">
                  <a class="lh-1 color-inherit text-decoration-none" href="#" data-bs-toggle="offcanvas" data-bs-target="#searchModal" aria-controls="searchModal" aria-expanded="false">
                    <svg class="icon icon-magnifying-glass-light fs-5">
                      <use xlink:href="#icon-magnifying-glass-light"></use>
                    </svg>
                    <span class="fs-15px">Search</span>
                  </a>
                </div>
              </div>
              
              <ul class="navbar-nav w-100 w-xl-auto">
                <li class="nav-item transition-all-xl-1 py-xl-11 py-0 px-xxl-8 px-xl-6">
                  <a class="nav-link d-flex justify-content-between position-relative py-xl-0 px-xl-0 text-uppercase fw-semibold ls-1 fs-15px fs-xl-14px" href="<?=base_url()?>">Home</a>
                </li>
                <li class="nav-item transition-all-xl-1 py-xl-11 py-0 px-xxl-8 px-xl-6">
                  <a class="nav-link d-flex justify-content-between position-relative py-xl-0 px-xl-0 text-uppercase fw-semibold ls-1 fs-15px fs-xl-14px" href="<?=base_url('home/about')?>">About</a>
                </li>
                <li class="nav-item transition-all-xl-1 py-xl-11 py-0 px-xxl-8 px-xl-6">
                  <a class="nav-link d-flex justify-content-between position-relative py-xl-0 px-xl-0 text-uppercase fw-semibold ls-1 fs-15px fs-xl-14px" href="<?=base_url('products')?>">Shop</a>
                </li>
              </ul>
            </div>
            
            <!-- Center Logo -->
            <div class="d-none d-xl-flex align-items-center">
              <a href="<?=base_url()?>" class="navbar-brand px-8 py-4 mx-auto">
                <img class="light-mode-img header-logo-img" width="50px" height="auto" src="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_dark'))->s_value;?>" alt="<?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?>">
                <img class="dark-mode-img header-logo-img" width="50px" height="auto" src="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_white_text'))->s_value;?>" alt="<?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?>">
              </a>
            </div>
            
            <!-- Right Navigation -->
            <div class="w-auto w-xl-50 d-flex align-items-center">
              <ul class="navbar-nav w-100 w-xl-auto">
                <li class="nav-item transition-all-xl-1 py-xl-11 py-0 px-xxl-8 px-xl-6">
                  <a class="nav-link d-flex justify-content-between position-relative py-xl-0 px-xl-0 text-uppercase fw-semibold ls-1 fs-15px fs-xl-14px" href="<?=base_url('faqs')?>">FAQs</a>
                </li>
                <li class="nav-item transition-all-xl-1 py-xl-11 py-0 px-xxl-8 px-xl-6">
                  <a class="nav-link d-flex justify-content-between position-relative py-xl-0 px-xl-0 text-uppercase fw-semibold ls-1 fs-15px fs-xl-14px" href="<?=base_url('contact')?>">Contact</a>
                </li>
              </ul>
              
              <!-- Right Icons -->
              <div class="icons-actions d-none d-xl-flex justify-content-end ms-auto fs-28px text-body-emphasis">
                <!-- Account -->
                <div class="px-5 d-none d-xl-inline-block">
                  <?php if (isset($_SESSION) && $_SESSION['login']->userId){ ?>
                    <a class="lh-1 color-inherit text-decoration-none" href="<?=base_url('account')?>">
                      <svg class="icon icon-user-light">
                        <use xlink:href="#icon-user-light"></use>
                      </svg>
                    </a>
                  <?php }else{ ?>
                    <a class="lh-1 color-inherit text-decoration-none" href="<?=base_url('auth/login')?>">
                      <svg class="icon icon-user-light">
                        <use xlink:href="#icon-user-light"></use>
                      </svg>
                    </a>
                  <?php } ?>
                </div>
                
                <!-- Shopping Cart -->
                <div class="px-5 d-none d-xl-inline-block">
                  <a class="position-relative lh-1 color-inherit text-decoration-none" href="#" data-bs-toggle="offcanvas" data-bs-target="#shoppingCart" aria-controls="shoppingCart" aria-expanded="false">
                    <svg class="icon icon-star-light">
                      <use xlink:href="#icon-shopping-bag-open-light"></use>
                    </svg>
                    <span class="badge bg-dark text-white position-absolute top-0 start-100 translate-middle mt-4 rounded-circle fs-13px p-0 square cart-count" style="--square-size: 18px">0</span>
                  </a>
                </div>
                
                <!-- Theme Toggle -->
                <div class="color-modes position-relative ps-5">
                  <a class="bd-theme btn btn-link nav-link dropdown-toggle d-inline-flex align-items-center justify-content-center text-primary p-0 position-relative rounded-circle" href="#" aria-expanded="true" data-bs-toggle="dropdown" data-bs-display="static" aria-label="Toggle theme">
                    <svg class="bi my-1 theme-icon-active"><use href="#sun-fill"></use></svg>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end fs-14px" data-bs-popper="static">
                    <li>
                      <button type="button" class="dropdown-item d-flex align-items-center active" data-bs-theme-value="light" aria-pressed="true">
                        <svg class="bi me-4 opacity-50 theme-icon"><use href="#sun-fill"></use></svg>
                        Light
                        <svg class="bi ms-auto d-none"><use href="#check2"></use></svg>
                      </button>
                    </li>
                    <li>
                      <button type="button" class="dropdown-item d-flex align-items-center" data-bs-theme-value="dark" aria-pressed="false">
                        <svg class="bi me-4 opacity-50 theme-icon"><use href="#moon-stars-fill"></use></svg>
                        Dark
                        <svg class="bi ms-auto d-none"><use href="#check2"></use></svg>
                      </button>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
          
        </div>
      </div>
    </div>
  </header>
  
  <!-- Mobile Off-Canvas Navigation -->
  <div class="offcanvas offcanvas-start" tabindex="-1" id="offCanvasNavBar" aria-labelledby="offCanvasNavBarLabel">
    <div class="offcanvas-header border-bottom py-5">
      <a href="<?=base_url()?>" class="offcanvas-title" id="offCanvasNavBarLabel">
        <img class="header-logo-img" src="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_dark'))->s_value;?>" alt="<?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?>">
      </a>
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body py-10">
      <ul class="navbar-nav">
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url()?>">Home</a>
        </li>
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url('home/about')?>">About</a>
        </li>
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url('products')?>">Shop</a>
        </li>
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url('faqs')?>">FAQs</a>
        </li>
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url('contact')?>">Contact</a>
        </li>
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url('products/cart')?>">Shopping Cart</a>
        </li>
        <?php if (isset($_SESSION) && $_SESSION['login']->userId){ ?>
          <li class="nav-item transition-all-xl-1 py-0">
            <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url('account')?>">My Account</a>
          </li>
        <?php }else{ ?>
          <li class="nav-item transition-all-xl-1 py-0">
            <a class="nav-link d-flex justify-content-between position-relative text-uppercase fw-semibold ls-1 fs-15px py-4" href="<?=base_url('auth/login')?>">Login / Register</a>
          </li>
        <?php } ?>
        <hr class="my-4">
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative fw-medium fs-15px py-4" href="<?=base_url('privacy')?>">Service</a>
        </li>
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative fw-medium fs-15px py-4" href="<?=base_url('privacy/policy')?>">Privacy Policy</a>
        </li>
        <li class="nav-item transition-all-xl-1 py-0">
          <a class="nav-link d-flex justify-content-between position-relative fw-medium fs-15px py-4" href="<?=base_url('terms')?>">Terms of Service</a>
        </li>
      </ul>
    </div>
    <hr class="mb-0">
    <div class="offcanvas-footer bg-body-tertiary p-6">
      <?=$this->settings_m->getOne(array('s_key' => 'footer_text'))->s_value;?>
    </div>
  </div>
  
  <!-- Search Modal -->
  <div class="offcanvas offcanvas-top" tabindex="-1" id="searchModal" aria-labelledby="searchModalLabel">
    <div class="offcanvas-header border-bottom">
      <h5 class="offcanvas-title" id="searchModalLabel">Search Products</h5>
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      <div class="container py-10">
        <form action="<?=base_url('products')?>" method="get" class="d-flex">
          <input class="form-control form-control-lg me-2" type="search" name="name" placeholder="Search for products..." aria-label="Search" required>
          <button class="btn btn-dark btn-lg px-10" type="submit">Search</button>
        </form>
      </div>
    </div>
  </div>
  
  <?php } ?>
  
  <!-- Main Content Wrapper -->
  <main id="content" class="wrapper layout-page">
