  </main>
  <!-- End Main Content Wrapper -->

<?php if ($this->uri->segment(2) == "checkout" || $this->uri->segment(2) == "payment" || $this->uri->segment(2) == "order_success"){ }else{ ?>
  
  <!-- Footer -->
  <footer class="pt-16 pt-lg-20 pb-16 footer bg-body-tertiary">
    <div class="container container-xxl pt-4">
      <div class="row">
        <!-- Brand Description -->
        <div class="col-lg-5 col-12 mb-11 mb-lg-0">
          <h3 class="mb-6"><?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?></h3>
          <p class="pe-xl-24 mb-lg-11">Luxury fragrances that embody strength and sophistication. Experience the essence of elegance.</p>
          <a class="fw-semibold fs-6 text-decoration-none" href="<?=base_url('products')?>">
            Pre-Order Now <svg class="icon ms-5"><use xlink:href="#icon-arrow-right"></use></svg>
          </a>
        </div>
        
        <!-- Company Links -->
        <div class="col-lg col-md-4 col-12 mb-11 mb-lg-0">
          <h3 class="fs-5 mb-6">Company</h3>
          <ul class="list-unstyled mb-0 fw-medium">
            <li class="pt-3 mb-4">
              <a href="<?=base_url('home/about')?>" title="About us" class="text-body">About Us</a>
            </li>
            <li class="pt-3 mb-4">
              <a href="<?=base_url('products')?>" title="Shop" class="text-body">Shop</a>
            </li>
            <li class="pt-3 mb-4">
              <a href="<?=base_url('contact')?>" title="Contact" class="text-body">Contact Us</a>
            </li>
          </ul>
        </div>
        
        <!-- Useful Links -->
        <div class="col-lg col-md-4 col-12 mb-11 mb-lg-0">
          <h3 class="fs-5 mb-6">Shop</h3>
          <ul class="list-unstyled mb-0 fw-medium">
            <?php $categories = $this->categories_m->getAll(); ?>
            <?php if($categories): foreach($categories as $category): ?>
              <li class="pt-3 mb-4">
                <a href="<?=base_url('products?category='.$category->categoryUnique)?>" title="<?=$category->category_name?>" class="text-body"><?=$category->category_name?></a>
              </li>
            <?php endforeach; endif; ?>
            <li class="pt-3 mb-4">
              <a href="<?=base_url('products/cart')?>" title="Cart" class="text-body">My Pre-Orders</a>
            </li>
          </ul>
        </div>
        
        <!-- Information Links -->
        <div class="col-lg col-md-4 col-12 mb-11 mb-lg-0">
          <h3 class="fs-5 mb-6">Information</h3>
          <ul class="list-unstyled mb-0 fw-medium">
            <li class="pt-3 mb-4">
              <a href="<?=base_url('faqs')?>" title="FAQs" class="text-body">FAQs</a>
            </li>
            <li class="pt-3 mb-4">
              <a href="<?=base_url('privacy')?>" title="Service" class="text-body">Service</a>
            </li>
            <li class="pt-3 mb-4">
              <a href="<?=base_url('terms')?>" title="Terms & Conditions" class="text-body">Terms &amp; Conditions</a>
            </li>
            <li class="pt-3 mb-4">
              <a href="<?=base_url('privacy/policy')?>" title="Privacy Policy" class="text-body">Privacy Policy</a>
            </li>
          </ul>
        </div>
      </div>
      
      <!-- Footer Bottom -->
      <div class="row align-items-center mt-0 mt-lg-20 pt-lg-4">
        <div class="col-sm-12 col-md-6 col-lg-4 d-flex align-items-center order-2 order-lg-1 fs-6 mt-11 mt-lg-0">
          <p class="mb-0"><?=$this->settings_m->getOne(array('s_key' => 'footer_text'))->s_value;?></p>
          <ul class="list-inline fs-18px ms-6 mb-0">
            <?php $twitter = $this->settings_m->getOne(array('s_key' => 'twitter_link')); if($twitter && $twitter->s_value): ?>
            <li class="list-inline-item me-8">
              <a href="<?=$twitter->s_value?>" target="_blank"><i class="fab fa-twitter"></i></a>
            </li>
            <?php endif; ?>
            <?php $facebook = $this->settings_m->getOne(array('s_key' => 'facebook_link')); if($facebook && $facebook->s_value): ?>
            <li class="list-inline-item me-8">
              <a href="<?=$facebook->s_value?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
            </li>
            <?php endif; ?>
            <?php $instagram = $this->settings_m->getOne(array('s_key' => 'instagram_link')); if($instagram && $instagram->s_value): ?>
            <li class="list-inline-item me-8">
              <a href="<?=$instagram->s_value?>" target="_blank"><i class="fab fa-instagram"></i></a>
            </li>
            <?php endif; ?>
          </ul>
        </div>
        <div class="col-sm-12 col-lg-4 text-md-center order-1 order-lg-2">
          <a class="d-inline-block" href="<?=base_url()?>">
            <img class="light-mode-img img-fluid" src="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_dark'))->s_value;?>" width="120" alt="<?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?>">
            <img class="dark-mode-img img-fluid" src="<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'app_logo_white_text'))->s_value;?>" width="120" alt="<?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?>">
          </a>
        </div>
        <div class="col-sm-12 col-md-6 col-lg-4 order-3 text-sm-start text-lg-end mt-11 mt-lg-0">
          <img src="<?=base_url()?>frontend/assets/images/footer/img_1.png" width="313" height="28" alt="Payment Methods" class="img-fluid">
        </div>
      </div>
    </div>
  </footer>
  
<?php } ?>

  <!-- Pre-Order Cart Sidebar -->
  <?php $carts = $this->cart_m->getFilter(array('cart.userUnique' => getUserUnique(), 'cart.status' => 0)); ?>
  <div class="offcanvas offcanvas-end" tabindex="-1" id="shoppingCart" aria-labelledby="shoppingCartLabel">
    <div class="offcanvas-header border-bottom py-5">
      <h5 class="offcanvas-title" id="shoppingCartLabel">Your Pre-Orders</h5>
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body result-cart">
      <?php $this->load->view('layout/_cart_sidebar', ['carts' => $carts]); ?>
    </div>
  </div>

  <!-- Back to Top -->
  <div class="position-fixed z-index-10 bottom-0 end-0 p-10">
    <a href="#" class="gtf-back-to-top text-decoration-none bg-body text-primary bg-primary-hover text-light-hover shadow square p-0 rounded-circle d-flex align-items-center justify-content-center" title="Back To Top" style="--square-size: 48px">
      <i class="fa-solid fa-arrow-up"></i>
    </a>
  </div>

  <!-- Vendor Scripts -->
  <script src="<?=base_url()?>frontend/assets/vendors/bootstrap/js/bootstrap.bundle.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/vanilla-lazyload/lazyload.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/waypoints/jquery.waypoints.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/lightgallery/lightgallery.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/lightgallery/plugins/zoom/lg-zoom.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/lightgallery/plugins/thumbnail/lg-thumbnail.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/slick/slick.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/gsap/gsap.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/gsap/ScrollToPlugin.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/gsap/ScrollTrigger.min.js"></script>
  <script src="<?=base_url()?>frontend/assets/vendors/clipboard/clipboard.min.js"></script>
  
  <!-- Theme Script -->
  <script src="<?=base_url()?>frontend/assets/js/theme.min.js"></script>
  
  <!-- Toastify -->
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>

  <!-- Custom Scripts -->
  <script>
    // Update cart count
    $('.cart-count').html('<?=count($carts)?>')

    function increase(input){
      var update = document.getElementById('setQty'+input);
      if (null != update.value) {
        let value = parseInt(update.value, 10);
        (value = isNaN(value) ? 0 : value), value++, (update.value = value);
        updateQty(input)
      }
    }

    function decrease(input){
      var update = document.getElementById('setQty'+input);
      if (null != update.value) {
        let value = parseInt(update.value, 10);
        if (value > 1) {
          (value = isNaN(value) ? 1 : value), value < 1 && (value = 1), value--, (update.value = value);
          updateQty(input)
        }
      }
    }

    function updateQty(cartId){
      var formData = {
        quantity: $("#setQty"+cartId).val(),
        cartId: cartId
      };

      $.ajax({
        type: "POST",
        url: "<?=base_url('products/update_to_cart')?>",
        data: formData,
        dataType: "json",
        encode: true,
      }).done(function (data) {
        if(data.status == 1){
          successMessage(data.message);
          $('.result-cart').html(data.html);
        }else if(data.status == 2){
          errorMessage(data.message);
          window.location.href = "<?=base_url('auth/login')?>";
        }else {
          errorMessage(data.message);
        }
      });
    }

    function errorMessage(message){
      Toastify({
        text: message,
        duration: 3000,
        newWindow: true,
        close: true,
        gravity: "top",
        position: "center",
        stopOnFocus: true,
        style: { background: "#dc3545" },
        onClick: function(){}
      }).showToast();
    }

    function successMessage(message){
      Toastify({
        text: message,
        duration: 3000,
        newWindow: true,
        close: true,
        gravity: "top",
        position: "center",
        stopOnFocus: true,
        style: { background: "#198754" },
        onClick: function(){}
      }).showToast();
    }

    function remove_cart(cartId){
      var formData = { cartId: cartId };

      $.ajax({
        type: "POST",
        url: "<?=base_url('products/remove_from_cart')?>",
        data: formData,
        dataType: "json",
        encode: true,
      }).done(function (data) {
        if(data.status == 1){
          successMessage(data.message);
          $('.result-cart').html(data.html);
          $('.cart-count').html(data.count);
        }else if(data.status == 2){
          errorMessage(data.message);
          window.location.href = "<?=base_url('auth/login')?>";
        }else {
          errorMessage(data.message);
        }
      });
    }
  </script>

  <?php if($this->session->flashdata('success')){ ?>
    <script>
      Toastify({
        text: "<?=$this->session->flashdata('success')?>",
        duration: 3000,
        newWindow: true,
        close: true,
        gravity: "top",
        position: "center",
        stopOnFocus: true,
        style: { background: "#198754" },
        onClick: function(){}
      }).showToast();
    </script>
  <?php } ?>

  <?php if($this->session->flashdata('error')){ ?>
    <script>
      Toastify({
        text: "<?=$this->session->flashdata('error')?>",
        duration: 3000,
        newWindow: true,
        close: true,
        gravity: "top",
        position: "center",
        stopOnFocus: true,
        style: { background: "#dc3545" },
        onClick: function(){}
      }).showToast();
    </script>
  <?php } ?>

  <!-- SVG Icons Sprite -->
  <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
    <!-- Search Icon -->
    <symbol id="icon-magnifying-glass-light" viewBox="0 0 512 512">
      <path fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32" d="M221.09 64a157.09 157.09 0 10157.09 157.09A157.1 157.1 0 00221.09 64z"/>
      <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-miterlimit="10" stroke-width="32" d="M338.29 338.29L448 448"/>
    </symbol>
    
    <!-- User Icon -->
    <symbol id="icon-user-light" viewBox="0 0 512 512">
      <path d="M344 144c-3.92 52.87-44 96-88 96s-84.15-43.12-88-96c-4-55 35-96 88-96s92 42 88 96z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/>
      <path d="M256 304c-87 0-175.3 48-191.64 138.6C62.39 453.52 68.57 464 80 464h352c11.44 0 17.62-10.48 15.65-21.4C431.3 352 343 304 256 304z" fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32"/>
    </symbol>
    
    <!-- Star/Wishlist Icon -->
    <symbol id="icon-star-light" viewBox="0 0 576 512">
      <path fill="currentColor" d="M287.9 0c9.2 0 17.6 5.2 21.6 13.5l68.6 141.3 153.2 22.6c9 1.3 16.5 7.6 19.3 16.3s.5 18.1-5.9 24.5L433.6 328.4l26.2 155.6c1.5 9-2.2 18.1-9.6 23.5s-17.3 6-25.3 1.7l-137-73.2L151 509.1c-8.1 4.3-17.9 3.7-25.3-1.7s-11.2-14.5-9.7-23.5l26.2-155.6L31.1 218.2c-6.5-6.4-8.7-15.9-5.9-24.5s10.3-14.9 19.3-16.3l153.2-22.6L266.3 13.5C270.4 5.2 278.7 0 287.9 0zm0 79L235.4 187.2c-3.5 7.1-10.2 12.1-18.1 13.3L99 217.9 184.9 303c5.5 5.5 8.1 13.3 6.8 21L searching176.1 443.7l105.5-56.4c7-3.8 15.6-3.8 22.6 0l105.5 56.4L searching394.2 324c-1.3-7.7 1.2-15.5 6.8-21l85.9-85.1L searching369.8 200.5c-7.9-1.2-14.6-6.1-18.1-13.3L287.9 79z"/>
    </symbol>
    
    <!-- Shopping Bag Icon -->
    <symbol id="icon-shopping-bag-open-light" viewBox="0 0 576 512">
      <path fill="currentColor" d="M0 24C0 10.7 10.7 0 24 0H69.5c22 0 41.5 12.8 50.6 32h411c26.3 0 45.5 25 38.6 50.4l-41 152.3c-8.5 31.4-37 53.3-69.5 53.3H170.7l5.4 28.5c2.2 11.3 12.1 19.5 23.6 19.5H488c13.3 0 24 10.7 24 24s-10.7 24-24 24H199.7c-34.6 0-64.3-24.6-70.7-58.5L77.4 54.5c-.7-3.8-4-6.5-7.9-6.5H24C10.7 48 0 37.3 0 24zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"/>
    </symbol>
    
    <!-- Arrow Right Icon -->
    <symbol id="icon-arrow-right" viewBox="0 0 448 512">
      <path fill="currentColor" d="M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L searching233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"/>
    </symbol>
    
    <!-- Sun Icon (Light Mode) -->
    <symbol id="sun-fill" viewBox="0 0 16 16">
      <path d="M8 12a4 4 0 1 0 0-8 4 4 0 0 0 0 8zM8 0a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 0zm0 13a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 13zm8-5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5zM3 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2A.5.5 0 0 1 3 8zm10.657-5.657a.5.5 0 0 1 0 .707l-1.414 1.415a.5.5 0 1 1-.707-.708l1.414-1.414a.5.5 0 0 1 .707 0zm-9.193 9.193a.5.5 0 0 1 0 .707L3.05 13.657a.5.5 0 0 1-.707-.707l1.414-1.414a.5.5 0 0 1 .707 0zm9.193 2.121a.5.5 0 0 1-.707 0l-1.414-1.414a.5.5 0 0 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .707zM4.464 4.465a.5.5 0 0 1-.707 0L2.343 3.05a.5.5 0 1 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .708z"/>
    </symbol>
    
    <!-- Moon Icon (Dark Mode) -->
    <symbol id="moon-stars-fill" viewBox="0 0 16 16">
      <path d="M6 .278a.768.768 0 0 1 .08.858 7.208 7.208 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277.527 0 1.04-.055 1.533-.16a.787.787 0 0 1 .81.316.733.733 0 0 1-.031.893A8.349 8.349 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71 0 4.266 2.114 1.312 5.124.06A.752.752 0 0 1 6 .278z"/>
      <path d="M10.794 3.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387a1.734 1.734 0 0 0-1.097 1.097l-.387 1.162a.217.217 0 0 1-.412 0l-.387-1.162A1.734 1.734 0 0 0 9.31 6.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387a1.734 1.734 0 0 0 1.097-1.097l.387-1.162zM13.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732l-.774-.258a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L13.863.1z"/>
    </symbol>
    
    <!-- Circle Half Icon (Auto Mode) -->
    <symbol id="circle-half" viewBox="0 0 16 16">
      <path d="M8 15A7 7 0 1 0 8 1v14zm0 1A8 8 0 1 1 8 0a8 8 0 0 1 0 16z"/>
    </symbol>
    
    <!-- Check Icon -->
    <symbol id="check2" viewBox="0 0 16 16">
      <path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/>
    </symbol>
    
    <!-- Eye Icon (Quick View) -->
    <symbol id="icon-eye-light" viewBox="0 0 576 512">
      <path fill="currentColor" d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.4 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/>
    </symbol>
    
    <!-- Arrows Left Right Icon (Compare) -->
    <symbol id="icon-arrows-left-right-light" viewBox="0 0 512 512">
      <path fill="currentColor" d="M406.6 374.6l96-96c12.5-12.5 12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224l-293.5 0 41.4-41.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 288l293.5 0-41.4 41.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z"/>
    </symbol>
  </svg>

</body>
</html>
