<?php if($carts && count($carts) > 0): ?>
    <?php $total = 0; ?>
    <div class="cart-items">
        <?php foreach ($carts as $cart): ?>
            <?php
                $item_price = $cart->amount;
                if($cart->discount_percentage) {
                    $item_price = $cart->amount - ($cart->amount * ($cart->discount_percentage / 100));
                }
                $amountXqty = $item_price * $cart->quantity;
                $total = $total + $amountXqty;
            ?>
            <div class="cart-item d-flex py-6 border-bottom">
                <div class="cart-item-thumb flex-shrink-0" style="width: 100px; height: 120px; overflow: hidden;">
                    <a href="<?=base_url('products/view/'.$cart->slug.'/'.$cart->productUnique)?>">
                        <img src="<?=PRODUCT_ASSETS_URL.$cart->image?>" alt="<?=$cart->name?>" class="img-fluid object-fit-cover w-100 h-100">
                    </a>
                </div>
                <div class="cart-item-details flex-grow-1 ps-6">
                    <h6 class="mb-2">
                        <a href="<?=base_url('products/view/'.$cart->slug.'/'.$cart->productUnique)?>" class="text-decoration-none text-body-emphasis"><?=$cart->name?></a>
                    </h6>
                    <?php if($cart->colorName): ?>
                        <span class="d-block text-muted fs-14px"><b>Color:</b> <?=$cart->colorName?></span>
                    <?php endif; ?>
                    <?php if($cart->size): ?>
                        <span class="d-block text-muted fs-14px"><b>Size:</b> <?=$cart->size?></span>
                    <?php endif; ?>
                    
                    <div class="cart-item-price my-4">
                        <?php if($cart->discount_percentage): ?>
                            <span class="text-body-emphasis fw-semibold"><?=currency_main_symbol($item_price, 1)?></span>
                            <span class="text-muted text-decoration-line-through ms-2"><?=currency_main_symbol($cart->amount, 1)?></span>
                        <?php else: ?>
                            <span class="text-body-emphasis fw-semibold"><?=currency_main_symbol($cart->amount, 1)?></span>
                        <?php endif; ?>
                    </div>
                    
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="quantity-selector d-flex align-items-center border rounded">
                            <button type="button" class="btn btn-sm px-4 py-2 border-0" onclick="decrease('<?=$cart->cartId?>')">-</button>
                            <input type="number" min="1" class="form-control form-control-sm text-center border-0" id="setQty<?=$cart->cartId?>" value="<?=$cart->quantity?>" style="width: 50px;" readonly>
                            <button type="button" class="btn btn-sm px-4 py-2 border-0" onclick="increase('<?=$cart->cartId?>')">+</button>
                        </div>
                        <button class="btn btn-link text-danger p-0 fs-14px" onclick="remove_cart('<?=$cart->cartId?>')">Remove</button>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <div class="cart-totals py-6">
        <div class="d-flex justify-content-between mb-4">
            <span>Sub Total:</span>
            <span class="fw-semibold"><?=currency_main_symbol($total, 1)?></span>
        </div>
        <div class="d-flex justify-content-between mb-6">
            <span>Total:</span>
            <span class="fw-bold fs-5"><?=currency_main_symbol($total, 1)?></span>
        </div>
    </div>
    
    <div class="cart-actions d-grid gap-4">
        <a class="btn btn-outline-dark" href="<?=base_url('cart')?>">View Pre-Orders</a>
        <a class="btn btn-dark" href="<?=base_url('checkout')?>">Complete Pre-Order</a>
    </div>
<?php else: ?>
    <div class="text-center py-20">
        <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" class="bi bi-cart-x text-muted mb-6" viewBox="0 0 16 16">
            <path d="M7.354 5.646a.5.5 0 1 0-.708.708L7.793 7.5 6.646 8.646a.5.5 0 1 0 .708.708L8.5 8.207l1.146 1.147a.5.5 0 0 0 .708-.708L9.207 7.5l1.147-1.146a.5.5 0 0 0-.708-.708L8.5 6.793 7.354 5.646z"/>
            <path d="M.5 1a.5.5 0 0 0 0 1h1.11l.401 1.607 1.498 7.985A.5.5 0 0 0 4 12h1a2 2 0 1 0 0 4 2 2 0 0 0 0-4h7a2 2 0 1 0 0 4 2 2 0 0 0 0-4h1a.5.5 0 0 0 .491-.408l1.5-8A.5.5 0 0 0 14.5 3H2.89l-.405-1.621A.5.5 0 0 0 2 1H.5zm3.915 10L3.102 4h10.796l-1.313 7h-8.17zM6 14a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm7 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0z"/>
        </svg>
        <p class="text-muted mb-6">No pre-orders yet</p>
        <a class="btn btn-dark" href="<?=base_url('products')?>">Browse Products</a>
    </div>
<?php endif; ?>

