<!-- Hero Slider Section -->
<style>
    .hero-text-overlay {
        text-shadow: 0 2px 4px rgba(0,0,0,0.3), 0 4px 12px rgba(0,0,0,0.15);
    }
    .hero-text-overlay h1 {
        color: #fff !important;
        text-shadow: 0 2px 8px rgba(0,0,0,0.4), 0 4px 16px rgba(0,0,0,0.2);
    }
    .hero-text-overlay p {
        color: rgba(255,255,255,0.95) !important;
    }
    .hero-text-overlay a {
        color: #fff !important;
        text-shadow: 0 1px 3px rgba(0,0,0,0.3);
    }
    .hero-text-overlay a:hover {
        color: rgba(255,255,255,0.85) !important;
    }
    .hero-gradient-overlay {
        background: linear-gradient(90deg, rgba(0,0,0,0.55) 0%, rgba(0,0,0,0.35) 50%, rgba(0,0,0,0.1) 100%);
    }
</style>
<section>
    <div class="slick-slider hero hero-header-05 slick-slider-dots-inside"
         data-slick-options='{"arrows":false,"autoplay":true,"cssEase":"ease-in-out","dots":true,"fade":true,"infinite":true,"slidesToShow":1,"speed":600}'>
        
        <?php if(isset($banners) && count($banners) > 0): ?>
            <?php foreach($banners as $banner): ?>
                <div class="vh-100 d-flex align-items-center position-relative overflow-hidden">
                    <!-- Background Image -->
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1" style="background: url('<?=BANNER_ASSETS_URL.$banner->bannerImage?>') center center / cover no-repeat;"></div>
                    <!-- Gradient Overlay for text readability -->
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1 hero-gradient-overlay"></div>
                    <!-- Content -->
                    <div class="z-index-2 container container-xxl py-21 pt-xl-10 pb-xl-11">
                        <div class="hero-content hero-text-overlay text-start">
                            <div data-animate="fadeInDown">
                                <?php if($banner->bannerSubtitle): ?>
                                    <p class="mb-8 fw-semibold fs-4"><?=$banner->bannerSubtitle?></p>
                                <?php endif; ?>
                                <?php if($banner->bannerTitle): ?>
                                    <h1 class="mb-11 hero-title-5"><?=$banner->bannerTitle?></h1>
                                <?php endif; ?>
                            </div>
                            <a href="<?=$banner->bannerAction ?: base_url('products')?>" data-animate="fadeInUp" class="pb-2 bg-transparent fw-semibold text-decoration-none hero-link p-0 fs-6">
                                Discover Now
                                <svg class="icon">
                                    <use xlink:href="#icon-arrow-right"></use>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <!-- Slide 1 - Pre-Order -->
            <div class="vh-100 d-flex align-items-center position-relative overflow-hidden">
                <!-- Background Image -->
                <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1 light-mode-img" style="background: url('<?=base_url()?>frontend/assets/images/hero-slider/hero-slider-13.jpg') center center / cover no-repeat;"></div>
                <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1 dark-mode-img" style="background: url('<?=base_url()?>frontend/assets/images/hero-slider/hero-slider-white-13.jpg') center center / cover no-repeat;"></div>
                <!-- Gradient Overlay -->
                <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1 hero-gradient-overlay"></div>
                <!-- Content -->
                <div class="z-index-2 container container-xxl py-21 pt-xl-10 pb-xl-11">
                    <div class="hero-content hero-text-overlay text-start">
                        <div data-animate="fadeInDown">
                            <p class="mb-8 fw-semibold fs-4">Pre-Order Now Open</p>
                            <h1 class="mb-11 hero-title-5">Be The First<br>To Experience Luxury</h1>
                        </div>
                        <a href="<?=base_url('products')?>" data-animate="fadeInUp" class="pb-2 bg-transparent fw-semibold text-decoration-none hero-link p-0 fs-6">
                            Pre-Order Now
                            <svg class="icon">
                                <use xlink:href="#icon-arrow-right"></use>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Slide 2 - Exclusive Collection -->
            <div class="vh-100 d-flex align-items-center position-relative overflow-hidden">
                <!-- Background Image -->
                <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1 light-mode-img" style="background: url('<?=base_url()?>frontend/assets/images/hero-slider/hero-slider-14.jpg') center center / cover no-repeat;"></div>
                <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1 dark-mode-img" style="background: url('<?=base_url()?>frontend/assets/images/hero-slider/hero-slider-white-14.jpg') center center / cover no-repeat;"></div>
                <!-- Gradient Overlay -->
                <div class="position-absolute top-0 start-0 w-100 h-100 z-index-1 hero-gradient-overlay"></div>
                <!-- Content -->
                <div class="z-index-2 container container-xxl py-21 pt-xl-10 pb-xl-11">
                    <div class="hero-content hero-text-overlay text-start">
                        <div data-animate="fadeInDown">
                            <p class="mb-8 fw-semibold fs-4">Exclusive Collection</p>
                            <h1 class="mb-11 hero-title-5">Reserve Your<br>Signature Scent</h1>
                        </div>
                        <a href="<?=base_url('products')?>" data-animate="fadeInUp" class="pb-2 bg-transparent fw-semibold text-decoration-none hero-link p-0 fs-6">
                            Explore Collection
                            <svg class="icon">
                                <use xlink:href="#icon-arrow-right"></use>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
    </div>
</section>

<!-- Shop by Categories Section -->
<section class="container container-xxl py-14 py-lg-17">
    <div class="mb-13">
        <div class="text-center" data-animate="fadeInUp">
            <h2 class="mb-6">Shop by Categories</h2>
            <p class="fs-18px mb-0">Discover our exclusive fragrance collections.</p>
        </div>
    </div>
    
    <div class="row">
        <?php if(isset($categories) && count($categories) > 0): ?>
            <?php $total_categories = count($categories); ?>
            
            <?php if($total_categories == 1): ?>
                <!-- Single category - full width -->
                <div class="col-12" data-animate="fadeInUp">
                    <div class="card border-0 rounded-0 hover-zoom-in hover-shine">
                        <?php if($categories[0]->category_image): ?>
                            <img class="card-img object-fit-cover img-fluid" style="max-height: 500px;" src="<?=CATEGORY_ASSETS_URL.$categories[0]->category_image?>" alt="<?=$categories[0]->category_name?>">
                        <?php else: ?>
                            <img class="card-img object-fit-cover img-fluid" style="max-height: 500px;" src="<?=base_url()?>frontend/assets/images/banner/banner-18.jpg" alt="<?=$categories[0]->category_name?>">
                        <?php endif; ?>
                        <div class="card-img-overlay d-inline-flex flex-column p-8 justify-content-end text-center">
                            <div>
                                <a href="<?=base_url('products?category='.$categories[0]->categoryUnique)?>" class="btn btn-white px-12"><?=$categories[0]->category_name?></a>
                            </div>
                        </div>
                    </div>
                </div>
                
            <?php elseif($total_categories == 2): ?>
                <!-- Two categories - equal size -->
                <?php foreach($categories as $index => $category): ?>
                    <div class="col-lg-6 mb-9 mb-lg-0" data-animate="fadeInUp">
                        <div class="card border-0 rounded-0 hover-zoom-in hover-shine h-100">
                            <?php if($category->category_image): ?>
                                <img class="card-img object-fit-cover img-fluid h-100" style="min-height: 400px;" src="<?=CATEGORY_ASSETS_URL.$category->category_image?>" alt="<?=$category->category_name?>">
                            <?php else: ?>
                                <img class="card-img object-fit-cover img-fluid h-100" style="min-height: 400px;" src="<?=base_url()?>frontend/assets/images/banner/banner-<?= $index == 0 ? '18' : '15' ?>.jpg" alt="<?=$category->category_name?>">
                            <?php endif; ?>
                            <div class="card-img-overlay d-inline-flex flex-column p-8 justify-content-end text-center">
                                <div>
                                    <a href="<?=base_url('products?category='.$category->categoryUnique)?>" class="btn btn-white px-12"><?=$category->category_name?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                
            <?php else: ?>
                <!-- 3+ categories - original layout with large first category -->
                <?php $count = 0; foreach($categories as $category): $count++; ?>
                    <?php if($count == 1): ?>
                        <!-- First category - large -->
                        <div class="col-lg-6 mb-9 mb-lg-0" data-animate="fadeInUp">
                            <div class="card border-0 rounded-0 hover-zoom-in hover-shine h-100">
                                <?php if($category->category_image): ?>
                                    <img class="card-img object-fit-cover img-fluid h-100" src="<?=CATEGORY_ASSETS_URL.$category->category_image?>" alt="<?=$category->category_name?>">
                                <?php else: ?>
                                    <img class="card-img object-fit-cover img-fluid h-100" src="<?=base_url()?>frontend/assets/images/banner/banner-18.jpg" alt="<?=$category->category_name?>">
                                <?php endif; ?>
                                <div class="card-img-overlay d-inline-flex flex-column p-8 justify-content-end text-center">
                                    <div>
                                        <a href="<?=base_url('products?category='.$category->categoryUnique)?>" class="btn btn-white px-12"><?=$category->category_name?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php elseif($count == 2): ?>
                        <div class="col-lg-6">
                            <div class="row">
                                <!-- Second category - small top left -->
                                <div class="col-md-6 mb-4" data-animate="fadeInUp">
                                    <div class="card border-0 rounded-0 hover-zoom-in hover-shine">
                                        <?php if($category->category_image): ?>
                                            <img class="card-img object-fit-cover img-fluid" src="<?=CATEGORY_ASSETS_URL.$category->category_image?>" width="330" height="330" alt="<?=$category->category_name?>">
                                        <?php else: ?>
                                            <img class="card-img object-fit-cover img-fluid" src="<?=base_url()?>frontend/assets/images/banner/banner-15.jpg" width="330" height="330" alt="<?=$category->category_name?>">
                                        <?php endif; ?>
                                        <div class="card-img-overlay d-inline-flex flex-column p-8 justify-content-end text-center">
                                            <div>
                                                <a href="<?=base_url('products?category='.$category->categoryUnique)?>" class="btn btn-white px-12"><?=$category->category_name?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                    <?php elseif($count == 3): ?>
                                <!-- Third category - small top right -->
                                <div class="col-md-6 mb-4" data-animate="fadeInUp">
                                    <div class="card border-0 rounded-0 hover-zoom-in hover-shine">
                                        <?php if($category->category_image): ?>
                                            <img class="card-img object-fit-cover img-fluid" src="<?=CATEGORY_ASSETS_URL.$category->category_image?>" width="330" height="330" alt="<?=$category->category_name?>">
                                        <?php else: ?>
                                            <img class="card-img object-fit-cover img-fluid" src="<?=base_url()?>frontend/assets/images/banner/banner-16.jpg" width="330" height="330" alt="<?=$category->category_name?>">
                                        <?php endif; ?>
                                        <div class="card-img-overlay d-inline-flex flex-column p-8 justify-content-end text-center">
                                            <div>
                                                <a href="<?=base_url('products?category='.$category->categoryUnique)?>" class="btn btn-white px-12"><?=$category->category_name?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php elseif($count == 4): ?>
                            <!-- Fourth category - wide bottom -->
                            <div class="row">
                                <div class="col-12" data-animate="fadeInUp">
                                    <div class="card border-0 rounded-0 hover-zoom-in hover-shine">
                                        <?php if($category->category_image): ?>
                                            <img class="card-img object-fit-cover img-fluid" src="<?=CATEGORY_ASSETS_URL.$category->category_image?>" width="690" height="330" alt="<?=$category->category_name?>">
                                        <?php else: ?>
                                            <img class="card-img object-fit-cover img-fluid" src="<?=base_url()?>frontend/assets/images/banner/banner-17.jpg" width="690" height="330" alt="<?=$category->category_name?>">
                                        <?php endif; ?>
                                        <div class="card-img-overlay d-inline-flex flex-column p-8 justify-content-end text-center">
                                            <div>
                                                <a href="<?=base_url('products?category='.$category->categoryUnique)?>" class="btn btn-white px-12"><?=$category->category_name?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($count >= 4) break; ?>
                <?php endforeach; ?>
                
                <?php // Close divs if we have exactly 3 categories ?>
                <?php if($count == 3): ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        <?php else: ?>
            <!-- No categories - show placeholder -->
            <div class="col-12 text-center py-10">
                <p class="text-muted">No categories available yet.</p>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Featured Products / Pre-Order Section -->
<section id="our_best_seller">
    <div class="container container-xxl mb-20">
        <div class="mb-13 text-center" data-animate="fadeInUp">
            <h2 class="mb-5">Available for Pre-Order</h2>
            <p class="fs-18px mb-0 mw-xl-35 mw-lg-50 mw-md-75 ms-auto me-auto px-xl-5">
                Be among the first to own our exclusive fragrances. Reserve yours today before they sell out.
            </p>
        </div>

        <?php if(isset($featured_products) && count($featured_products) > 0): ?>
            <div class="slick-slider" data-slick-options='{"arrows":true,"dots":false,"responsive":[{"breakpoint":1560,"settings":{"arrows":false,"dots":true}},{"breakpoint":1200,"settings":{"arrows":false,"dots":true,"slidesToShow":3}},{"breakpoint":992,"settings":{"arrows":false,"dots":true,"slidesToShow":2}},{"breakpoint":576,"settings":{"arrows":false,"dots":true,"slidesToShow":1}}],"slidesToShow":4}'>
                <?php foreach($featured_products as $product): ?>
                    <div>
                        <div class="card card-product grid-1 bg-transparent border-0" data-animate="fadeInUp">
                            <figure class="card-img-top position-relative mb-7 overflow-hidden">
                                <a href="<?=base_url('products/view/'.$product->slug.'/'.$product->productUnique)?>" class="hover-zoom-in d-block" title="<?=$product->name?>">
                                    <img src="<?=PRODUCT_ASSETS_URL.$product->image?>" class="img-fluid w-100" alt="<?=$product->name?>" width="330" height="440">
                                </a>
                                
                                <?php if($product->discount_percentage): ?>
                                    <div class="position-absolute product-flash z-index-2">
                                        <span class="badge badge-product-flash on-sale bg-primary">-<?=$product->discount_percentage?>%</span>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="position-absolute d-flex z-index-2 product-actions horizontal">
                                    <button type="button" 
                                            class="text-body-emphasis bg-body bg-dark-hover text-light-hover rounded-circle square product-action shadow-sm border-0 quick-add-to-cart" 
                                            data-product-unique="<?=$product->productUnique?>"
                                            data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Quick Pre-Order">
                                        <svg class="icon icon-shopping-bag-open-light">
                                            <use xlink:href="#icon-shopping-bag-open-light"></use>
                                        </svg>
                                    </button>
                                    <a class="text-body-emphasis bg-body bg-dark-hover text-light-hover rounded-circle square product-action shadow-sm" 
                                       href="<?=base_url('products/view/'.$product->slug.'/'.$product->productUnique)?>" 
                                       data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Quick View">
                                        <svg class="icon icon-eye-light">
                                            <use xlink:href="#icon-eye-light"></use>
                                        </svg>
                                    </a>
                                </div>
                            </figure>
                            
                            <div class="card-body text-center p-0">
                                <!-- Price -->
                                <span class="d-flex align-items-center price text-body-emphasis fw-bold justify-content-center mb-3 fs-6">
                                    <?php if($product->discount_percentage): ?>
                                        <del class="text-body fw-500 me-4 fs-13px"><?=currency_main_symbol($product->amount, 1)?></del>
                                        <ins class="text-decoration-none"><?=currency_main_symbol($product->amount, 1, true, $product->discount_percentage)?></ins>
                                    <?php else: ?>
                                        <?=currency_main_symbol($product->amount, 1)?>
                                    <?php endif; ?>
                                </span>
                                
                                <!-- Product Title -->
                                <h4 class="product-title card-title text-primary-hover text-body-emphasis fs-15px fw-500 mb-3">
                                    <a class="text-decoration-none text-reset" href="<?=base_url('products/view/'.$product->slug.'/'.$product->productUnique)?>"><?=$product->name?></a>
                                </h4>
                                
                                <!-- Category -->
                                <?php if($product->category_name): ?>
                                    <p class="text-muted fs-13px mb-0"><?=$product->category_name?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-10">
                <p class="text-muted">No products available yet.</p>
                <a href="<?=base_url('products')?>" class="btn btn-dark">Browse All Products</a>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Coming Soon / New Arrivals Section -->
<?php if(isset($new_products) && count($new_products) > 0): ?>
<section class="py-14 py-lg-17 bg-body-tertiary">
    <div class="container container-xxl">
        <div class="mb-13 text-center" data-animate="fadeInUp">
            <h2 class="mb-5">Coming Soon</h2>
            <p class="fs-18px mb-0">The latest additions to our exclusive fragrance collection. Pre-order now to secure yours.</p>
        </div>

        <div class="row justify-content-center">
            <?php foreach($new_products as $product): ?>
                <div class="col-lg-3 col-md-6 mb-9" data-animate="fadeInUp">
                    <div class="card card-product grid-1 bg-transparent border-0">
                        <figure class="card-img-top position-relative mb-7 overflow-hidden">
                            <a href="<?=base_url('products/view/'.$product->slug.'/'.$product->productUnique)?>" class="hover-zoom-in d-block" title="<?=$product->name?>">
                                <img src="<?=PRODUCT_ASSETS_URL.$product->image?>" class="img-fluid w-100" alt="<?=$product->name?>" width="330" height="440">
                            </a>
                            
                            <div class="position-absolute product-flash z-index-2">
                                <span class="badge badge-product-flash on-new">New</span>
                            </div>
                            
                            <div class="position-absolute d-flex z-index-2 product-actions horizontal">
                                <button type="button" 
                                        class="text-body-emphasis bg-body bg-dark-hover text-light-hover rounded-circle square product-action shadow-sm border-0 quick-add-to-cart" 
                                        data-product-unique="<?=$product->productUnique?>"
                                        data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Quick Pre-Order">
                                    <svg class="icon icon-shopping-bag-open-light">
                                        <use xlink:href="#icon-shopping-bag-open-light"></use>
                                    </svg>
                                </button>
                                <a class="text-body-emphasis bg-body bg-dark-hover text-light-hover rounded-circle square product-action shadow-sm" 
                                   href="<?=base_url('products/view/'.$product->slug.'/'.$product->productUnique)?>" 
                                   data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="View Product">
                                    <svg class="icon icon-eye-light">
                                        <use xlink:href="#icon-eye-light"></use>
                                    </svg>
                                </a>
                            </div>
                        </figure>
                        
                        <div class="card-body text-center p-0">
                            <span class="d-flex align-items-center price text-body-emphasis fw-bold justify-content-center mb-3 fs-6">
                                <?php if($product->discount_percentage): ?>
                                    <del class="text-body fw-500 me-4 fs-13px"><?=currency_main_symbol($product->amount, 1)?></del>
                                    <ins class="text-decoration-none"><?=currency_main_symbol($product->amount, 1, true, $product->discount_percentage)?></ins>
                                <?php else: ?>
                                    <?=currency_main_symbol($product->amount, 1)?>
                                <?php endif; ?>
                            </span>
                            
                            <h4 class="product-title card-title text-primary-hover text-body-emphasis fs-15px fw-500 mb-3">
                                <a class="text-decoration-none text-reset" href="<?=base_url('products/view/'.$product->slug.'/'.$product->productUnique)?>"><?=$product->name?></a>
                            </h4>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-6">
            <a href="<?=base_url('products')?>" class="btn btn-dark px-12">View All Pre-Orders</a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Call to Action / Brand Story Section -->
<section class="py-20 position-relative overflow-hidden">
    <div class="position-absolute z-index-1 w-100 h-100 top-0 start-0" style="background: url('<?=ASSETS_URL.$this->settings_m->getOne(array('s_key' => 'shop_now_banner'))->s_value;?>') center/cover no-repeat;"></div>
    <div class="bg-overlay position-absolute z-index-1 w-100 h-100" style="background-color: rgba(0,0,0,0.5);"></div>
    <div class="container container-xxl position-relative z-index-2">
        <div class="row justify-content-center">
            <div class="col-lg-8 text-center text-white">
                <h2 class="text-white mb-8" data-animate="fadeInUp"><?=$this->settings_m->getOne(array('s_key' => 'app_name'))->s_value;?></h2>
                <p class="fs-18px mb-11" data-animate="fadeInUp">
                    <?php 
                    $who_we_are = $this->settings_m->getOne(array('s_key' => 'who_we_are'));
                    if($who_we_are && $who_we_are->s_value):
                        echo strip_tags(substr($who_we_are->s_value, 0, 300)) . '...';
                    else:
                        echo 'Luxury fragrances crafted with passion and precision. Experience scents that tell a story.';
                    endif;
                    ?>
                </p>
                <div data-animate="fadeInUp">
                    <a href="<?=base_url('home/about')?>" class="btn btn-white px-12 me-4">Our Story</a>
                    <a href="<?=base_url('products')?>" class="btn btn-outline-white px-12">Pre-Order Now</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Pre-Order Benefits Section -->
<section class="py-14 py-lg-17">
    <div class="container container-xxl">
        <div class="row text-center">
            <div class="col-md-4 mb-9 mb-md-0" data-animate="fadeInUp">
                <div class="px-6">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-box-seam mb-6 text-primary" viewBox="0 0 16 16">
                        <path d="M8.186 1.113a.5.5 0 0 0-.372 0L1.846 3.5l2.404.961L10.404 2l-2.218-.887zm3.564 1.426L5.596 5 8 5.961 14.154 3.5l-2.404-.961zm3.25 1.7-6.5 2.6v7.922l6.5-2.6V4.24zM7.5 14.762V6.838L1 4.239v7.923l6.5 2.6zM7.443.184a1.5 1.5 0 0 1 1.114 0l7.129 2.852A.5.5 0 0 1 16 3.5v8.662a1 1 0 0 1-.629.928l-7.185 2.874a.5.5 0 0 1-.372 0L.63 13.09a1 1 0 0 1-.63-.928V3.5a.5.5 0 0 1 .314-.464L7.443.184z"/>
                    </svg>
                    <h5 class="mb-4">Priority Shipping</h5>
                    <p class="text-muted mb-0">Pre-order customers receive priority shipping when products launch</p>
                </div>
            </div>
            <div class="col-md-4 mb-9 mb-md-0" data-animate="fadeInUp">
                <div class="px-6">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-shield-check mb-6 text-primary" viewBox="0 0 16 16">
                        <path d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z"/>
                        <path d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z"/>
                    </svg>
                    <h5 class="mb-4">Guaranteed Availability</h5>
                    <p class="text-muted mb-0">Secure your order now and never miss out on limited editions</p>
                </div>
            </div>
            <div class="col-md-4" data-animate="fadeInUp">
                <div class="px-6">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-percent mb-6 text-primary" viewBox="0 0 16 16">
                        <path d="M13.442 2.558a.625.625 0 0 1 0 .884l-10 10a.625.625 0 1 1-.884-.884l10-10a.625.625 0 0 1 .884 0zM4.5 6a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3zm0 1a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5zm7 6a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3zm0 1a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5z"/>
                    </svg>
                    <h5 class="mb-4">Exclusive Pricing</h5>
                    <p class="text-muted mb-0">Pre-order customers enjoy special launch pricing and offers</p>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
$(document).ready(function() {
    // Quick Add to Cart
    $('.quick-add-to-cart').on('click', function() {
        var btn = $(this);
        var productUnique = btn.data('product-unique');
        
        btn.prop('disabled', true);
        
        $.ajax({
            type: 'POST',
            url: '<?=base_url("products/add_to_cart")?>',
            data: { 
                productUnique: productUnique,
                quantity: 1
            },
            dataType: 'json',
            success: function(response) {
                btn.prop('disabled', false);
                
                if (response.status === 'success') {
                    // Update cart count
                    $('.cart-count').text(response.cart_count);
                    
                    // Update cart sidebar HTML
                    if (response.cart_html) {
                        $('.result-cart').html(response.cart_html);
                    }
                    
                    if (typeof Toastify !== 'undefined') {
                        Toastify({
                            text: "Product added to pre-order!",
                            duration: 3000,
                            gravity: "top",
                            position: "right",
                            style: { background: "#28a745" },
                        }).showToast();
                    }
                } else {
                    if (typeof Toastify !== 'undefined') {
                        Toastify({
                            text: response.message || "Error adding product",
                            duration: 3000,
                            gravity: "top",
                            position: "right",
                            backgroundColor: "#dc3545",
                        }).showToast();
                    }
                }
            }
        });
    });
});
</script>

