<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transactions_m extends MY_Model {

    protected $table = 'transactions';
    protected $primary_key = 'checkoutID';

    public function __construct() {
        parent::__construct();
    }

    /**
     * Get payment method by channel code
     */
    public function getOnePaymentMethod($where) {
        return $this->db->where($where)->get('payment_methods')->row();
    }

    /**
     * Get user's orders
     */
    public function getUserOrders($userUnique) {
        $this->db->where('userUnique', $userUnique);
        $this->db->where('deleted', 0);
        $this->db->order_by('checkDate', 'DESC');
        return $this->db->get($this->table)->result();
    }

    /**
     * Get order by transaction unique
     */
    public function getByTransactionUnique($transactionUnique) {
        return $this->db->where('transactionUnique', $transactionUnique)->get($this->table)->row();
    }
}

