<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings_m extends MY_Model {

    protected $table = 'settings';
    protected $primary_key = 'settingsId';

    public function __construct() {
        parent::__construct();
    }

    /**
     * Get setting by key
     */
    public function getByKey($key) {
        return $this->db->where('s_key', $key)->get($this->table)->row();
    }

    /**
     * Get settings by group
     */
    public function getByGroup($group) {
        return $this->db->where('s_group', $group)->get($this->table)->result();
    }

    /**
     * Update setting value by key
     */
    public function updateByKey($key, $value) {
        return $this->db->where('s_key', $key)->update($this->table, ['s_value' => $value]);
    }

    /**
     * Get currency by conditions
     */
    public function getOneCurrency($where) {
        return $this->db->where($where)->get('currencies')->row();
    }

    /**
     * Get all currencies
     */
    public function getAllCurrencies() {
        return $this->db->get('currencies')->result();
    }
}

