<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Categories_m extends MY_Model {

    protected $table = 'categories';
    protected $primary_key = 'categoryId';

    public function __construct() {
        parent::__construct();
    }

    /**
     * Get all categories ordered by date
     */
    public function getAllCategories() {
        return $this->db->order_by('cateDateAdded', 'DESC')->get($this->table)->result();
    }

    /**
     * Get category by unique
     */
    public function getByUnique($categoryUnique) {
        return $this->db->where('categoryUnique', $categoryUnique)->get($this->table)->row();
    }

    /**
     * Get categories with product count
     */
    public function getCategoriesWithCount() {
        $this->db->select('categories.*, COUNT(products.productId) as product_count');
        $this->db->from('categories');
        $this->db->join('products', 'products.categoryUnique = categories.categoryUnique AND products.deleted = 0 AND products.product_status = 1', 'left');
        $this->db->group_by('categories.categoryId');
        $this->db->order_by('categories.cateDateAdded', 'DESC');
        return $this->db->get()->result();
    }

    /**
     * Get limited categories for homepage
     */
    public function getFeaturedCategories($limit = 4) {
        return $this->db->limit($limit)->order_by('cateDateAdded', 'DESC')->get($this->table)->result();
    }
}

