<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

    public function __construct() {
        parent::__construct();
        
        // Load required models
        $this->load->model('settings_m');
        $this->load->model('banners_m');
        $this->load->model('categories_m');
        $this->load->model('products_m');
        $this->load->model('cart_m');
        $this->load->model('transactions_m');
        
        // Load helpers
        $this->load->helper('url');
        
        // Start session if not started
        if (!session_id()) {
            session_start();
        }
        
        // Initialize session login if not set
        if (!isset($_SESSION['login'])) {
            $_SESSION['login'] = (object)[
                'userId' => null,
                'verification_link' => null
            ];
        }
    }

    /**
     * Homepage - displays banner sliders, categories, and products
     */
    public function index() {
        // Get banners for slider
        $data['banners'] = $this->banners_m->getActiveBanners();
        
        // Get categories
        $data['categories'] = $this->categories_m->getAllCategories();
        
        // Get featured/bestseller products
        $data['featured_products'] = $this->products_m->getFeaturedProducts(8);
        
        // Get new arrivals
        $data['new_products'] = $this->products_m->getNewArrivals(4);
        
        // Get products on sale
        $data['sale_products'] = $this->products_m->getOnSaleProducts(4);
        
        // Page content
        $data['content'] = 'home/index';
        
        // Load view with layout
        $this->load->view('_layout', $data);
    }

    /**
     * About page
     */
    public function about() {
        $data['content'] = 'home/about';
        $this->load->view('_layout', $data);
    }

    /**
     * Contact page
     */
    public function contact() {
        $data['content'] = 'home/contact';
        $this->load->view('_layout', $data);
    }
}

